<?php include ('includes/header.php') ?>

  <!-- Hero Section (Swiper) -->
  <section class="hero-section">
    <div class="swiper hero-swiper">
      <div class="swiper-wrapper">
        <div class="swiper-slide" style="background-image: url('assets/images/banner1.jpg')">
          <div class="slide-overlay"></div>
          <div class="hero-content container">
            <h1>THE FUTURE OF ROBOTIC TANK INSPECTIONS</h1>
            <p>At Varaha Techsols, we design and deploy advanced autonomous robotic systems that perform internal inspections of aboveground storage tanks — all while tanks remain fully operational and in service.</p>
            <a href="#" class="btn btn-primary">Request a Consultation</a>
          </div>
        </div>
        <div class="swiper-slide" style="background-image: url('assets/images/banner2.jpg')">
          <div class="slide-overlay"></div>
          <div class="hero-content container">
            <h1>PRECISION DATA, ZERO DOWNTIME</h1>
            <p>Our platforms collect high-resolution inspection data that enables predictive maintenance, compliance, and safer operations — without taking assets offline.</p>
            <a href="#" class="btn btn-primary">Request a Consultation</a>
          </div>
        </div>
        <div class="swiper-slide" style="background-image: url('assets/images/banner3.jpg')">
          <div class="slide-overlay"></div>
          <div class="hero-content container">
            <h1>GLOBAL ON-STREAM INSPECTIONS</h1>
            <p>We deploy around the globe to deliver reliable, on-stream robotic inspections tailored to each site's configuration and regulatory needs.</p>
            <a href="#" class="btn btn-primary">Request a Consultation</a>
          </div>
        </div>
      </div>
      <!-- Add Pagination -->
      <div class="swiper-pagination"></div>
      <!-- Add Navigation -->
      <div class="swiper-button-next" aria-label="Next slide"></div>
      <div class="swiper-button-prev" aria-label="Previous slide"></div>
    </div>
  </section>

  <!-- Empowering Data-Driven Decisions (enhanced) -->
  <section class="section data-decision">
    <div class="container">
      <div class="row align-items-center">
        <div class="col-md-7">
          <h2>Empowering Data-Driven Decisions</h2>
          <p class="lead">Our robotic inspections deliver high-resolution data and comprehensive reports that help industries make smarter, data-backed maintenance decisions. Each inspection ensures full regulatory compliance while safeguarding your people, reducing environmental impact, and saving the enormous costs typically required to take tanks offline.</p>

          <ul class="features-list list-unstyled mt-4">
            <li><i class="fas fa-check-circle"></i> High-density, high-resolution datasets</li>
            <li><i class="fas fa-check-circle"></i> Rapid, on-stream deployment with zero downtime</li>
            <li><i class="fas fa-check-circle"></i> Actionable analytics for predictive maintenance</li>
          </ul>

          <div class="mt-4">
            <a href="#" class="btn btn-primary">Learn How</a>
            <a href="#" class="btn btn-outline-theme ms-2">Request Demo</a>
          </div>
        </div>
        <div class="col-md-5">
          <div class="stats-card">
            <div class="stat-row">
              <div class="stat">
                <div class="stat-value">99.8<span class="stat-suffix">%</span></div>
                <div class="stat-label">Detection Accuracy</div>
              </div>
              <div class="stat">
                <div class="stat-value">0<span class="stat-suffix">hrs</span></div>
                <div class="stat-label">Operational Downtime</div>
              </div>
            </div>
            <div class="stat-row mt-3">
              <div class="stat">
                <div class="stat-value">100<span class="stat-suffix">+</span></div>
                <div class="stat-label">Global Deployments</div>
              </div>
              <div class="stat">
                <div class="stat-value">24/7</div>
                <div class="stat-label">Support</div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>

  <!-- Regulatory Compliance -->
  <section class="section regulatory-section">
    <div class="container">
      <div class="row align-items-center">
        <div class="col-lg-6 text-left">
          <h2>Regulatory Compliance Without Downtime</h2>
          <p class="lead">Varaha Techsols performs API 653 and EEMUA 159 compliant inspections using autonomous platforms under live operating conditions — eliminating confined space entry and keeping operations running.</p>

          <ul class="reg-features list-unstyled mt-4">
            <li><i class="fas fa-check-circle"></i> API 653 & EEMUA 159 compliant workflows</li>
            <li><i class="fas fa-check-circle"></i> No confined-space entry required</li>
            <li><i class="fas fa-check-circle"></i> Detailed traceable reports for audits</li>
          </ul>

          <div class="mt-4">
            <a href="#" class="btn btn-primary">Request Compliance Audit</a>
            <a href="#" class="btn btn-outline-theme ms-2">Learn More</a>
          </div>
        </div>
        <!-- <div class="col-lg-5">
          <div class="accent-card p-4">
            <div class="card-top d-flex align-items-center justify-content-between">
              <div>
                <h6 class="mb-1">Certifications</h6>
                <div class="certs">
                  <span class="badge">API 653</span>
                  <span class="badge">EEMUA 159</span>
                </div>
              </div>
              <div class="badge-icon">
                <i class="fas fa-shield-alt fa-2x"></i>
              </div>
            </div>

            <div class="card-body mt-3">
              <p class="mb-2">Inspection insights delivered with audit-ready reporting, traceability, and expert analysis.</p>
              <div class="quick-stats d-flex gap-3 mt-3">
                <div class="stat">
                  <div class="value">100%</div>
                  <div class="label">Compliance-ready</div>
                </div>
                <div class="stat">
                  <div class="value">0 hrs</div>
                  <div class="label">Downtime</div>
                </div>
              </div>
            </div>
          </div>
        </div> -->
      </div>
    </div>
  </section>

  <!-- Global Solutions -->
  <section class="section global-solutions">
    <div class="container">
      <div class="text-center">
        <div class="section-subtitle">Delivering Global On-Stream</div>
        <h2 class="section-title">Robotic Tank Inspection Solutions</h2>
        <p class="mt-3">We help industries worldwide enhance operational performance and asset reliability with on-stream robotic inspection services. From oil & gas to petrochemicals, we enable clients to achieve higher productivity, optimized costs, and improved safety — backed by complete regulatory assurance.</p>
      </div>
    </div>
  </section>

  <!-- Our Technology -->
  <section class="section our-technology regulatory-section">
    <div class="container">
      <div class="text-center">
        <div class="our-tech-subtitle">Our Technology</div>
        <h2 class="our-tech-title">Next-Generation Robotics</h2>
      </div>
      <div class="row">
        <div class="col-md-4">
          <div class="card">
            <h3>State-of-the-Art Robotic Systems</h3>
            <p>Our autonomous submersible robots are designed to achieve near-total inspection coverage — even in critical tank bottom zones where corrosion risks are highest.</p>
          </div>
        </div>
        <div class="col-md-4">
          <div class="card">
            <h3>Data-Centric Innovation</h3>
            <p>We use a tech-driven approach powered by high-density data acquisition and intelligent analysis — turning inspection insights into actionable intelligence.</p>
          </div>
        </div>
        <div class="col-md-4">
          <div class="card">
            <h3>Operational Excellence</h3>
            <p>Our mobile command units and efficient logistics ensure rapid global deployment. Robots can be launched through the roof or shell manways, adapting to any tank configuration.</p>
          </div>
        </div>
      </div>
    </div>
  </section>

  <!-- Core Values -->
  <section class="section core-values">
    <div class="container">
      <h2>Our Core Values</h2>
      <div class="row">
        <div class="col-md-3">
          <div class="card">
            <h3>Environmental, Social, and Governance (ESG)</h3>
            <p>Our on-stream robotic inspections eliminate confined space entry and significantly reduce carbon emissions and industrial waste. This means cleaner air, safer jobs, and more sustainable operations.</p>
          </div>
        </div>
        <div class="col-md-3">
          <div class="card">
            <h3>Commercial Value</h3>
            <p>Our robotic inspections save hundreds of thousands to millions per tank by keeping assets in service while ensuring compliance and safety.</p>
          </div>
        </div>
        <div class="col-md-3">
          <div class="card">
            <h3>Advanced Data Insights</h3>
            <p>With massive, high-resolution datasets from our advanced sensors, we bring inspections into the era of AI-driven analytics and predictive maintenance.</p>
          </div>
        </div>
        <div class="col-md-3">
          <div class="card">
            <h3>Operational Efficiency</h3>
            <p>No need for alternate storage, cleaning, or waste disposal. Our autonomous robots deliver reliable inspection data while your tanks stay operational.</p>
          </div>
        </div>
      </div>
    </div>
  </section>

  <!-- Call to Action (creative with background) -->
  <section class="section cta-section">
    <div class="container d-flex justify-content-center">
      <div class="cta-card text-center">
        <h2>Experience Safer, Smarter, and More Sustainable Tank Inspections</h2>
        <p>Partner with Varaha Techsols to keep your assets operational, compliant, and future-ready. Our autonomous inspections deliver rich insights without taking equipment offline.</p>
        <div class="cta-buttons d-flex justify-content-center gap-3">
          <a href="#" class="btn btn-cta-primary">Request a Demo</a>
          <a href="#" class="btn btn-cta-ghost">Talk to an Expert</a>
        </div>
        <div class="mt-3" style="font-size:0.9rem;color:rgba(255,255,255,0.7)">
          <span><i class="fas fa-check-circle"></i> Zero downtime inspections</span>
          <span class="ms-3"><i class="fas fa-shield-alt"></i> Audit-ready reporting</span>
        </div>
      </div>
    </div>
  </section>

<?php include ('includes/footer.php') ?>